<?php namespace App\Controllers;

use App\Controllers\BaseController;
use App\Models\SettingsModel;

class settings extends BaseController
{
    protected $session, $settings;

    public function __construct()
    {
        $this->session = session();
        $this->settings= new SettingsModel();
    }

    public function index()
    {
        if(!isset($this->session->id_usuario)) {return redirect()->to(base_url());}
        $settings=$this -> settings->where('id',1)->first();
        $data=['titulo' => 'Editar Configuración', 'datos' => $settings];

        echo view('header');
        echo view('settings',$data);
        echo view('footer');
    }

    public function actualizar()
    {
        if(!isset($this->session->id_usuario)) {return redirect()->to(base_url());}
        $this->settings->update($this->request->getPost('id'), [
        'nombre' => $this->request->getPost('nombre'),
        'telefono' => $this->request->getPost('telefono'),
        'email' => $this->request->getPost('email'),
        'direccion' => $this->request->getPost('direccion'),
        'caja' => $this->request->getPost('caja')]);
        
        if ($this->request->getFile('imagen')->isValid()) {
            $imagen = $this->request->getFile('imagen');
            if ( is_file('./img/Logo.jpg')) {
                unlink('./img/Logo.jpg');
            }
            $imagen->move('./img/','Logo.jpg');
        }

        return redirect()->to(base_url().'/home');        
    }   
}