<?php namespace App\Controllers;

use App\Controllers\BaseController;
use App\Models\ProtocoloModel;
use App\Models\PersonalModel;
use App\Models\ObraModel;
use App\Models\ServiciosModel;

class protocolo extends BaseController
{
    protected $protocolo, $obra, $personal, $servicios;

    public function __construct()
    {
        $this->protocolo= new ProtocoloModel();
        $this->obra= new ObraModel();
        $this->personal= new PersonalModel();
        $this->servicios= new ServiciosModel();
    }

    public function index()
    {
        $protocolo=$this->protocolo->orderby("fecha", "asc")->where('estado','FINALIZADO')->findAll();
        $data=['vTITULO' => 'Fojas Quirúrgicas - Turnos Finalizados', 'vDATOS' => $protocolo];

        echo view('header');
        echo view('protocolo/listado',$data);
        echo view('footer');
    }

    public function turnos()
    {
        $protocolo=$this->protocolo->select('protocolo.*, obra.nombre AS A, personal.nombre AS B, servicios.nombre AS C')->join('obra', 'obra.id = protocolo.paciente_obra')->join('personal', 'personal.id = protocolo.cirujano1')->join('servicios', 'servicios.id = protocolo.servicio')->where('estado <>','FINALIZADO')->findAll();
        $data=['vTITULO' => 'Lista de Turnos', 'vDATOS' => $protocolo];

        echo view('header');
        echo view('protocolo/turnos',$data);
        echo view('footer');
    }

    public function nuevo()
    {
        /* if(!isset($this->session->id_usuario)) {return redirect()->to(base_url());} */
        $obras=$this -> obra->orderby("sigla", "asc")->findAll();
        $servicios=$this -> servicios->orderby("id", "asc")->findAll();
        $cirujanos=$this -> personal->orderby("nombre", "asc")->where('especialidad','Cirujano')->findAll();        
        $data=['vTITULO' => 'Nuevo Ingreso', 'vOBRAS' => $obras, 'vSERVICIOS' => $servicios, 'vCIRUJANOS' => $cirujanos];        

        echo view('header');
        echo view('protocolo/nuevo',$data);
        echo view('footer');
    }

    public function insertar()
    {
        /* if(!isset($this->session->id_usuario)) {return redirect()->to(base_url());} */
        $this->protocolo->save([
        'paciente_nombre' => $this->request->getPost('paciente_nombre'),
        'paciente_dni' => $this->request->getPost('paciente_dni'),
        'paciente_obra' => $this->request->getPost('paciente_obra'),
        'paciente_tel' => $this->request->getPost('paciente_tel'),
        'servicio' => $this->request->getPost('servicio'),        
        'prioridad' => $this->request->getPost('prioridad'),
        'diagnostico_pre' => $this->request->getPost('diagnostico_pre'),
        'operacion' => $this->request->getPost('operacion'),
        'cirujano1' => $this->request->getPost('cirujano'),        
        'estado' => $this->request->getPost('estado')]);

        return redirect()->to(base_url().'/protocolo/turnos');
    }

    public function ver_turno($id)
    {
        /* if(!isset($this->session->id_usuario)) {return redirect()->to(base_url());} */
        $protocolo=$this->protocolo->select('protocolo.*, obra.nombre AS A')->join('obra', 'obra.id = protocolo.paciente_obra')->where('protocolo.id',$id)->first();
        $servicio=$this->protocolo->select('protocolo.*, servicios.nombre AS B')->join('servicios', 'servicios.id = protocolo.servicio')->where('protocolo.id',$id)->first();
        $data=['vTITULO' => 'Ver Turno', 'vDATOS' => $protocolo, 'mSERVICIOS' => $servicio];

        echo view('header');
        echo view('protocolo/ver_turno',$data);
        echo view('footer');
    }

    public function editar_turno($id)
    {
        /* if(!isset($this->session->id_usuario)) {return redirect()->to(base_url());} */
        $protocolo=$this -> protocolo->where('id',$id)->first();
        $obras=$this -> obra->orderby("nombre", "asc")->findAll();
        $servicios=$this -> servicios->orderby("nombre", "asc")->findAll();
        $cirujanos=$this -> personal->orderby("nombre", "asc")->where('especialidad','Cirujano')->findAll();
        $data=['vTITULO' => 'Editar Ingreso', 'vDATOS' => $protocolo, 'mSERVICIOS' => $servicios, 'vOBRAS' => $obras, 'vCIRUJANOS' => $cirujanos];

        echo view('header');
        echo view('protocolo/editar_turno',$data);
        echo view('footer');
    }

    public function actualizar_turno()
    {
        /* if(!isset($this->session->id_usuario)) {return redirect()->to(base_url());} */
        $this->protocolo->update($this->request->getPost('id'), [
            'paciente_nombre' => $this->request->getPost('paciente_nombre'),
            'servicio' => $this->request->getPost('servicio'),
            'paciente_dni' => $this->request->getPost('paciente_dni'),
            'fecha' => $this->request->getPost('fecha'),
            'paciente_obra' => $this->request->getPost('paciente_obra'),
            'paciente_afiliado' => $this->request->getPost('paciente_afiliado'),
            'diagnostico_pre' => $this->request->getPost('diagnostico_pre'),
            'operacion' => $this->request->getPost('operacion'),
            'prioridad' => $this->request->getPost('prioridad'),
            'cirujano1' => $this->request->getPost('cirujano'),
            'observaciones' => $this->request->getPost('observaciones'),
            'estado' => $this->request->getPost('estado')]);

            return redirect()->to(base_url().'/protocolo/turnos');
    }

    public function ver($id)
    {
        /* if(!isset($this->session->id_usuario)) {return redirect()->to(base_url());} */
        $protocolo=$this->protocolo->select('protocolo.*, obra.nombre AS A')->join('obra', 'obra.id = protocolo.paciente_obra')->where('protocolo.id',$id)->first();
        $B=$this->protocolo->select('protocolo.*, personal.nombre AS B')->join('personal', 'personal.id = protocolo.cirujano1')->where('protocolo.id',$id)->first();
        $C=$this->protocolo->select('protocolo.*, personal.nombre AS C')->join('personal', 'personal.id = protocolo.cirujano2')->where('protocolo.id',$id)->first();
        $D=$this->protocolo->select('protocolo.*, personal.nombre AS D')->join('personal', 'personal.id = protocolo.anestesiologo')->where('protocolo.id',$id)->first();
        $E=$this->protocolo->select('protocolo.*, personal.nombre AS E')->join('personal', 'personal.id = protocolo.ayudante1')->where('protocolo.id',$id)->first();
        $F=$this->protocolo->select('protocolo.*, personal.nombre AS F')->join('personal', 'personal.id = protocolo.ayudante2')->where('protocolo.id',$id)->first();
        $G=$this->protocolo->select('protocolo.*, personal.nombre AS G')->join('personal', 'personal.id = protocolo.circulante')->where('protocolo.id',$id)->first();
        $H=$this->protocolo->select('protocolo.*, personal.nombre AS H')->join('personal', 'personal.id = protocolo.instrumentista')->where('protocolo.id',$id)->first();
        $I=$this->protocolo->select('protocolo.*, personal.nombre AS I')->join('personal', 'personal.id = protocolo.patologo')->where('protocolo.id',$id)->first();
        $J=$this->protocolo->select('protocolo.*, servicios.nombre AS J')->join('servicios', 'servicios.id = protocolo.servicio')->where('protocolo.id',$id)->first();
        $data=['vTITULO' => 'Ver Foja Quirúrgica', 'vDATOS' => $protocolo, 'B' => $B, 'C' => $C, 'D' => $D, 'E' => $E, 'F' => $F, 'G' => $G, 'H' => $H, 'I' => $I, 'J' => $J];

        echo view('header');
        echo view('protocolo/ver',$data);
        echo view('footer');
    }

    public function editar($id)
    {
        /* if(!isset($this->session->id_usuario)) {return redirect()->to(base_url());} */
        $protocolo=$this -> protocolo->where('id',$id)->first();
        $obras=$this -> obra->orderby("nombre", "asc")->findAll();
        $servicios=$this -> servicios->orderby("nombre", "asc")->findAll();
        $cirujanos=$this -> personal->orderby("nombre", "asc")->where('especialidad','Cirujano')->findAll();
        $ayudantes=$this -> personal->orderby("nombre", "asc")->where('especialidad','Ayudante')->findAll();
        $anestesiologos=$this -> personal->orderby("nombre", "asc")->where('especialidad','Anestesiólogo')->findAll();
        $circulantes=$this -> personal->orderby("nombre", "asc")->where('especialidad','Circulante')->findAll();
        $instrumentistas=$this -> personal->orderby("nombre", "asc")->where('especialidad','Instrumentista')->findAll();
        $patologos=$this -> personal->orderby("nombre", "asc")->where('especialidad','Patólogo')->findAll();
        $data=['vTITULO' => 'Editar Foja Quirúrgica', 'vDATOS' => $protocolo, 'mSERVICIOS' => $servicios, 'vOBRAS' => $obras, 'vCIRUJANOS' => $cirujanos, 'vAYUDANTES' => $ayudantes, 'vANESTESIOLOGOS' => $anestesiologos, 'vINSTRUMENTISTAS' => $instrumentistas, 'vPATOLOGOS' => $patologos, 'vCIRCULANTES' => $circulantes];

        echo view('header');
        /* print_r($cirujanos); */
        echo view('protocolo/editar',$data);
        echo view('footer');
    }

    public function actualizar()
    {
        /* if(!isset($this->session->id_usuario)) {return redirect()->to(base_url());} */
        $this->protocolo->update($this->request->getPost('id'), [
            'paciente_nombre' => $this->request->getPost('paciente_nombre'),
            'servicio' => $this->request->getPost('servicio'),
            'paciente_dni' => $this->request->getPost('paciente_dni'),
            'fecha' => $this->request->getPost('fecha'),
            'paciente_edad' => $this->request->getPost('paciente_edad'),
            'paciente_obra' => $this->request->getPost('paciente_obra'),
            'paciente_afiliado' => $this->request->getPost('paciente_afiliado'),
            'paciente_grupo' => $this->request->getPost('paciente_grupo'),
            'cama' => $this->request->getPost('cama'),
            'paciente_direccion' => $this->request->getPost('paciente_direccion'),
            'diagnostico_pre' => $this->request->getPost('diagnostico_pre'),
            'diagnostico_pos' => $this->request->getPost('diagnostico_pos'),
            'cirujano1' => $this->request->getPost('cirujano1'),
            'cirujano2' => $this->request->getPost('cirujano2'),
            'anestesiologo' => $this->request->getPost('anestesiologo'),
            'ayudante1' => $this->request->getPost('ayudante1'),
            'ayudante2' => $this->request->getPost('ayudante2'),
            'circulante' => $this->request->getPost('circulante'),
            'instrumentista' => $this->request->getPost('instrumentista'),
            'patologo' => $this->request->getPost('patologo'),
            'patologo_detalle' => $this->request->getPost('patologo_detalle'),
            'operacion' => $this->request->getPost('operacion'),
            'operacion_detalle' => $this->request->getPost('operacion_detalle'),
            'materiales_des' => $this->request->getPost('materiales_des'),
            'materiales_pro' => $this->request->getPost('materiales_pro'),
            'prioridad' => $this->request->getPost('prioridad'),
            'estado' => $this->request->getPost('estado'),
            'observaciones' => $this->request->getPost('observaciones'),
            'duracion' => $this->request->getPost('duracion')]);

            return redirect()->to(base_url().'/protocolo');
    }

    public function imprimir($id)
    {
        /* if(!isset($this->session->id_usuario)) {return redirect()->to(base_url());} */
        $protocolo=$this ->protocolo->where('id',$id)->first();
        $obra=$this ->obra->where('id',$protocolo['paciente_obra'])->first();
        $cirujano1=$this->protocolo->select('personal.nombre AS A')->join('personal', 'protocolo.cirujano1 = personal.id')->where('protocolo.id',$id)->first();
        $cirujano2=$this->protocolo->select('personal.nombre AS A')->join('personal', 'protocolo.cirujano2 = personal.id')->where('protocolo.id',$id)->first();
        $anestesiologo=$this->protocolo->select('personal.nombre AS A')->join('personal', 'protocolo.anestesiologo = personal.id')->where('protocolo.id',$id)->first();
        $ayudante1=$this->protocolo->select('personal.nombre AS A')->join('personal', 'protocolo.ayudante1 = personal.id')->where('protocolo.id',$id)->first();
        $ayudante2=$this->protocolo->select('personal.nombre AS A')->join('personal', 'protocolo.ayudante2 = personal.id')->where('protocolo.id',$id)->first();
        $instrumentista=$this->protocolo->select('personal.nombre AS A')->join('personal', 'protocolo.instrumentista = personal.id')->where('protocolo.id',$id)->first();
        $patologo=$this->protocolo->select('personal.nombre AS A')->join('personal', 'protocolo.patologo = personal.id')->where('protocolo.id',$id)->first();
        $servicio=$this->protocolo->select('protocolo.*, servicios.nombre AS J')->join('servicios', 'servicios.id = protocolo.servicio')->where('protocolo.id',$id)->first();

        $pdf = new \FPDF('P', 'mm', array(210,297)); //Ancho - Alto de la hoja
        $pdf->AddPage();
        $pdf->SetLeftMargin(20); //márgen izquierdo en la hoja */
        /* $pdf->SetMargins(30, 25, 15); //márgenes izquierda, arriba y derecha */
        $pdf->SetFont('Arial', 'B', 10);
        $pdf->image(base_url() . '/img/logo_print.jpg', 20, 10, 55);
        $pdf->Ln(15);
        $pdf->SetFont('Arial', 'B', 16);
        $pdf->SetTitle(utf8_decode("Protocolo Quirúrgico"));
        $pdf->Ln(9);
        $pdf->SetFont('Arial', 'B', 'U', 18);
        $pdf->Cell(0, 0, utf8_decode("Protocolo Quirúrgico"), 0, 0, 'C');
        $pdf->Ln(5);
        $pdf->SetFont('Arial', '', 10);
        $pdf->Cell(0, 0, utf8_decode("Hospital Saporiti - Servicio de Quirófano"), 0, 0, 'C');
        $pdf->Ln(4);
        $pdf->SetFont('Arial', '', 9);
        $pdf->Cell(0, 0, utf8_decode("Tel. 263 - 4442253"), 0, 0, 'C');
        $pdf->Line(59, 50, 161, 50);
        $pdf->Ln(16);
        $pdf->SetFont('Arial', 'B', 11);
        $pdf->Cell(0, 4, utf8_decode ("Id: ". sprintf('%07d',$protocolo['id']) . "          " . "SERVICIO: ". $servicio['J']), 0, 1, 'L');
        $pdf->Ln(3);
        $pdf->SetFont('Arial', '', 10);
        $pdf->Cell(0, 4,"Paciente: ". $protocolo['paciente_nombre'] . "          " . "Documento: ". $protocolo['paciente_dni'] . "          " . "Fecha: ". $protocolo['fecha'], 0, 1, 'L');
        $pdf->Ln(2);
        $pdf->SetFont('Arial', '', 10);
        $pdf->Cell(0, 4,"Edad: ". $protocolo['paciente_edad'] . "          " . utf8_decode("Obra Social: ". $obra['sigla']) . "          " . utf8_decode("Número: ". $protocolo['paciente_afiliado']) . "          " . utf8_decode("Gpo. Sanguíneo: ". $protocolo['paciente_grupo']), 0, 1, 'L');
        $pdf->Ln(2);
        $pdf->MultiCell(0, 3, utf8_decode("Domicilio: ". $protocolo['paciente_direccion']), 0, 'J', false);
        $pdf->Ln(2);
        $pdf->Cell(0, 3, utf8_decode("Sala - Cama: ". $protocolo['cama']), 0, 1, 'L');
        $pdf->Ln(10);
        $pdf->SetFont('Arial', 'B', 14);
        $pdf->Cell(0, 5, utf8_decode("Diagnósticos"), 0, 1, 'C');
        $pdf->Ln(5);
        $pdf->SetFont('Arial', '', 10);
        $pdf->MultiCell(0, 4, utf8_decode("Diagnóstico Preparatorio: ". $protocolo['diagnostico_pre']), 0, 'J', false);
        $pdf->Ln(2);
        $pdf->MultiCell(0, 4, utf8_decode("Diagnóstico Posoperatorio: ". $protocolo['diagnostico_pos']), 0, 'J', false);
        $pdf->Ln(8);
        $pdf->SetFont('Arial', 'B', 14);
        $pdf->Cell(0, 5, utf8_decode("Equipo"), 0, 1, 'C');
        $pdf->Ln(5);
        $pdf->SetFont('Arial', '', 10);
        $pdf->Cell(0, 4, utf8_decode("Cirujano 1: ". $cirujano1['A']) . "          " . utf8_decode("Cirujano 2: ". $cirujano2['A']), 0, 1, 'L');
        $pdf->Ln(2);
        $pdf->Cell(0, 4, utf8_decode("Ayudante 1: ". $ayudante1['A']) . "          " . utf8_decode("Ayudante 2: ". $ayudante2['A']), 0, 1, 'L');
        $pdf->Ln(2);
        $pdf->Cell(0, 4, utf8_decode("Anestesiólogo: ". $anestesiologo['A']) . "          " . utf8_decode("Instrumentista: ". $instrumentista['A']), 0, 1, 'L');
        $pdf->Ln(4);
        $pdf->Cell(0, 4, utf8_decode("Patólogo: ". $patologo['A']), 0, 1, 'L');
        $pdf->Ln(2);
        $pdf->MultiCell(0, 4, utf8_decode("Detalle: ". $protocolo['patologo_detalle']), 0, 'J', false);
        $pdf->Ln(8);
        $pdf->SetFont('Arial', 'B', 14);
        $pdf->Cell(0, 5, utf8_decode("Operación - Técnica Quirúrgica"), 0, 1, 'C');
        $pdf->Ln(5);
        $pdf->SetFont('Arial', '', 10);
        $pdf->MultiCell(0, 4, utf8_decode("Operación: ". $protocolo['operacion']), 0, 'J', false);
        $pdf->Ln(2);
        $pdf->MultiCell(0, 4, utf8_decode("Detalle: ". $protocolo['operacion_detalle']), 0, 'J', false);
        $pdf->Ln(2);
        $pdf->MultiCell(0, 4, utf8_decode("Materiales Descartables: ". $protocolo['materiales_des']), 0, 'J', false);
        $pdf->Ln(2);
        $pdf->MultiCell(0, 4, utf8_decode("Materiales Protésicos: ". $protocolo['materiales_pro']), 0, 'J', false);
        $pdf->Ln(4);
        $pdf->Cell(0, 4, utf8_decode("Duración HH:MM: ". $protocolo['duracion']), 0, 1, 'L');

        /* $pdf->Settextcolor(255,255,255); */
        /* $pdf->SetFillColor(0,0,0); */

        $this->response->setHeader('Content-Type', 'application/pdf');
        $pdf->Output("Protocolo.pdf", "I");
    }
}