<?php namespace App\Controllers;

use App\Controllers\BaseController;
use App\Models\PersonalModel;

class personal extends BaseController
{
    protected $session, $personal;

    public function __construct()
    {
        $this->session = session();
        $this->personal= new PersonalModel();
    }

    public function index()
    {
        $personal=$this -> personal -> findAll();
        $datos=['titulo' => 'Lista de Personal', 'datos' => $personal];

        echo view('header');
        echo view('personal/listado',$datos);
        echo view('footer');
    }

    public function nuevo()
    {
        if(!isset($this->session->id_usuario)) {return redirect()->to(base_url());}
        $data=['vTITULO' => 'Nuevo Personal'];

        echo view('header');
        echo view('personal/nuevo',$data);
        echo view('footer');
    }

    public function insertar()
    {
        if(!isset($this->session->id_usuario)) {return redirect()->to(base_url());}
        $this->personal->save([
        'nombre' => strtoupper($this->request->getPost('nombre')),
        'especialidad' => $this->request->getPost('especialidad')]);
        return redirect()->to(base_url().'/personal');
    }

    public function editar($id)
    {
        if(!isset($this->session->id_usuario)) {return redirect()->to(base_url());}
        $personal=$this -> personal->where('id',$id)->first();
        $data=['vTITULO' => 'Editar Personal', 'vDATOS' => $personal];

        echo view('header');
        echo view('personal/editar',$data);
        echo view('footer');
    }

    public function actualizar()
    {
        if(!isset($this->session->id_usuario)) {return redirect()->to(base_url());}
        $this->personal->update($this->request->getPost('id'), [
        'nombre' => strtoupper($this->request->getPost('nombre')),
        'especialidad' => $this->request->getPost('especialidad')]);
        return redirect()->to(base_url().'/personal');
    }   
}