<?php namespace App\Controllers;

use App\Controllers\BaseController;
use App\Models\ObraModel;

class obra extends BaseController
{
    protected $session, $obra;

    public function __construct()
    {
        $this->session = session();
        $this->obra= new ObraModel();
    }

    public function index()
    {
        $datos=$this->obra->findAll();
        $data=['titulo' => 'Lista de Obras Sociales', 'datos' => $datos];

        echo view('header');
        echo view('obra/listado',$data);
        echo view('footer');
    }

    public function nuevo()
    {
        if(!isset($this->session->id_usuario)) {return redirect()->to(base_url());}
        $obra=$this ->obra -> findAll();
        $data=['vTITULO' => 'Nueva Obra Social', 'vDATOS' => $obra];

        echo view('header');
        echo view('obra/nuevo',$data);
        echo view('footer');
    }

    public function insertar()
    {
        if(!isset($this->session->id_usuario)) {return redirect()->to(base_url());}
        $this->obra->save([
            'nombre' => $this->request->getPost('nombre'),
            'sigla' => $this->request->getPost('sigla'),
            'domicilio' => $this->request->getPost('domicilio'),
            'provincia' => $this->request->getPost('provincia'),
            'telefono' => $this->request->getPost('telefono'),
            'email' => $this->request->getPost('email'),
            'web' => $this->request->getPost('web')]);
        return redirect()->to(base_url().'/obra');
    }
    
    public function ver($id)
    {
        if(!isset($this->session->id_usuario)) {return redirect()->to(base_url());}
        $obra=$this ->obra->where('id',$id)->first();

        $data=['vTITULO' => 'Ver Obra Social', 'vDATOS' => $obra];

        echo view('header');
        echo view('obra/ver',$data);
        echo view('footer');
    }

    public function editar($id)
    {
        if(!isset($this->session->id_usuario)) {return redirect()->to(base_url());}
        $obra=$this ->obra->where('id',$id)->first();

        $data=['vTITULO' => 'Editar Obra Social', 'vDATOS' => $obra];

        echo view('header');
        echo view('obra/editar',$data);
        echo view('footer');
    }

    public function actualizar()
    {
        if(!isset($this->session->id_usuario)) {return redirect()->to(base_url());}
        $this->obra->update($this->request->getPost('id'), [
        'nombre' => $this->request->getPost('nombre'),
        'sigla' => $this->request->getPost('sigla'),
        'domicilio' => $this->request->getPost('domicilio'),
        'provincia' => $this->request->getPost('provincia'),
        'telefono' => $this->request->getPost('telefono'),
        'email' => $this->request->getPost('email'),
        'web' => $this->request->getPost('web')]);

        return redirect()->to(base_url().'/obra');
    }
}