<?php namespace App\Controllers;

use App\Controllers\BaseController;
use App\Models\EstudioModel;
use App\Models\PersonalModel;
use App\Models\ObraModel;
use App\Models\PacientesModel;

class estudio extends BaseController
{
    protected $estudio, $obra, $personal, $pacientes;

    public function __construct()
    {
        $this->estudio= new EstudioModel();
        $this->obra= new ObraModel();
        $this->personal= new PersonalModel();
        $this->pacientes= new PacientesModel();
    }

    public function index()
    {
        $estudio=$this->estudio->select('estudio.*, pacientes.apellido AS J_apellido, pacientes.nombre AS J_nombre, diagnosticos.nombre AS J_diagnostico')->join('pacientes', 'pacientes.id = estudio.id_paciente')->join('diagnosticos', 'diagnosticos.id = estudio.id_diagnostico')->findAll();
        $data=['vTITULO' => 'Historial de Estudios', 'vDATOS' => $estudio];

        echo view('header');
        echo view('estudio/listado',$data);
        echo view('footer');
    }

    public function nuevo()
    {
        /* if(!isset($this->session->id_usuario)) {return redirect()->to(base_url());} */
        $obras=$this -> obra->orderby("sigla", "asc")->findAll();
        $servicios=$this -> servicios->orderby("id", "asc")->findAll();
        $cirujanos=$this -> personal->orderby("nombre", "asc")->where('especialidad','Cirujano')->findAll();        
        $data=['vTITULO' => 'Nuevo Turno', 'vOBRAS' => $obras, 'vSERVICIOS' => $servicios, 'vCIRUJANOS' => $cirujanos];        

        echo view('header');
        echo view('protocolo/nuevo',$data);
        echo view('footer');
    }

    public function insertar()
    {
        /* if(!isset($this->session->id_usuario)) {return redirect()->to(base_url());} */
        $this->protocolo->save([
        'paciente_nombre' => $this->request->getPost('paciente_nombre'),
        'paciente_dni' => $this->request->getPost('paciente_dni'),
/*         'fecha' => $this->request->getPost('fecha'), */
        'paciente_obra' => $this->request->getPost('paciente_obra'),
/*         'paciente_afiliado' => $this->request->getPost('paciente_afiliado'), */
        'paciente_tel' => $this->request->getPost('paciente_tel'),
        'servicio' => $this->request->getPost('servicio'),        
        'prioridad' => $this->request->getPost('prioridad'),
        'diagnostico_pre' => $this->request->getPost('diagnostico_pre'),
        'operacion' => $this->request->getPost('operacion'),
        'cirujano1' => $this->request->getPost('cirujano'),        
        'estado' => $this->request->getPost('estado')]);

        return redirect()->to(base_url().'/protocolo/turnos');
    }

    public function ver($id)
    {
        /* if(!isset($this->session->id_usuario)) {return redirect()->to(base_url());} */
        $estudio=$this->estudio->select('estudio.*, pacientes.*, materiales.nombre AS J_material, diagnosticos.nombre AS J_diagnostico, personal.apellido AS J_medicoA, personal.nombre AS J_medicoN, personal.matricula AS matricula')
        ->join('pacientes', 'pacientes.id = estudio.id_paciente')
        ->join('materiales', 'materiales.id = estudio.id_material')
        ->join('diagnosticos', 'diagnosticos.id = estudio.id_diagnostico')
        ->join('personal', 'personal.id = estudio.id_medico')
        ->first();
        $data=['vTITULO' => 'Ver Estudio', 'vDATOS' => $estudio];

        echo view('header');
        echo view('estudio/ver',$data);
        echo view('footer');
    }

    public function editar($id)
    {
        /* if(!isset($this->session->id_usuario)) {return redirect()->to(base_url());} */
        $protocolo=$this -> protocolo->where('id',$id)->first();
        $obras=$this -> obra->orderby("nombre", "asc")->findAll();
        $servicios=$this -> servicios->orderby("nombre", "asc")->findAll();
        $cirujanos=$this -> personal->orderby("nombre", "asc")->where('especialidad','Cirujano')->findAll();
        $ayudantes=$this -> personal->orderby("nombre", "asc")->where('especialidad','Ayudante')->findAll();
        $anestesiologos=$this -> personal->orderby("nombre", "asc")->where('especialidad','Anestesiólogo')->findAll();
        $circulantes=$this -> personal->orderby("nombre", "asc")->where('especialidad','Circulante')->findAll();
        $instrumentistas=$this -> personal->orderby("nombre", "asc")->where('especialidad','Instrumentista')->findAll();
        $patologos=$this -> personal->orderby("nombre", "asc")->where('especialidad','Patólogo')->findAll();
        $data=['vTITULO' => 'Editar Foja Quirúrgica', 'vDATOS' => $protocolo, 'mSERVICIOS' => $servicios, 'vOBRAS' => $obras, 'vCIRUJANOS' => $cirujanos, 'vAYUDANTES' => $ayudantes, 'vANESTESIOLOGOS' => $anestesiologos, 'vINSTRUMENTISTAS' => $instrumentistas, 'vPATOLOGOS' => $patologos, 'vCIRCULANTES' => $circulantes];

        echo view('header');
        /* print_r($cirujanos); */
        echo view('protocolo/editar',$data);
        echo view('footer');
    }

    public function actualizar()
    {
        /* if(!isset($this->session->id_usuario)) {return redirect()->to(base_url());} */
        $this->protocolo->update($this->request->getPost('id'), [
            'paciente_nombre' => $this->request->getPost('paciente_nombre'),
            'servicio' => $this->request->getPost('servicio'),
            'paciente_dni' => $this->request->getPost('paciente_dni'),
            'fecha' => $this->request->getPost('fecha'),
            'paciente_edad' => $this->request->getPost('paciente_edad'),
            'paciente_obra' => $this->request->getPost('paciente_obra'),
            'paciente_afiliado' => $this->request->getPost('paciente_afiliado'),
            'paciente_grupo' => $this->request->getPost('paciente_grupo'),
            'cama' => $this->request->getPost('cama'),
            'paciente_direccion' => $this->request->getPost('paciente_direccion'),
            'diagnostico_pre' => $this->request->getPost('diagnostico_pre'),
            'diagnostico_pos' => $this->request->getPost('diagnostico_pos'),
            'cirujano1' => $this->request->getPost('cirujano1'),
            'cirujano2' => $this->request->getPost('cirujano2'),
            'anestesiologo' => $this->request->getPost('anestesiologo'),
            'ayudante1' => $this->request->getPost('ayudante1'),
            'ayudante2' => $this->request->getPost('ayudante2'),
            'circulante' => $this->request->getPost('circulante'),
            'instrumentista' => $this->request->getPost('instrumentista'),
            'patologo' => $this->request->getPost('patologo'),
            'patologo_detalle' => $this->request->getPost('patologo_detalle'),
            'operacion' => $this->request->getPost('operacion'),
            'operacion_detalle' => $this->request->getPost('operacion_detalle'),
            'materiales_des' => $this->request->getPost('materiales_des'),
            'materiales_pro' => $this->request->getPost('materiales_pro'),
            'prioridad' => $this->request->getPost('prioridad'),
            'estado' => $this->request->getPost('estado'),            
            'duracion' => $this->request->getPost('duracion')]);

            return redirect()->to(base_url().'/protocolo');
    }

}