<?php namespace App\Controllers;

use App\Controllers\BaseController;
use App\Models\DiagnosticosModel;

class diagnosticos extends BaseController
{
    protected $session, $diagnosticos;

    public function __construct()
    {
        $this->session = session();
        $this->diagnosticos= new DiagnosticosModel();
    }

    public function index()
    {
        $diagnosticos=$this -> diagnosticos -> findAll();
        $datos=['vTITULO' => 'Listado de Diagnósticos', 'vDATOS' => $diagnosticos];

        echo view('header');
        echo view('diagnosticos/listado',$datos);
        echo view('footer');
    }

    public function nuevo()
    {
        if(!isset($this->session->id_usuario)) {return redirect()->to(base_url());}
        $data=['vTITULO' => 'Nuevo Servicio'];

        echo view('header');
        echo view('servicios/nuevo',$data);
        echo view('footer');
    }

    public function insertar()
    {
        if(!isset($this->session->id_usuario)) {return redirect()->to(base_url());}
        $this->servicios->save([
        'nombre' => $this->request->getPost('nombre')]);
        return redirect()->to(base_url().'/servicios');
    }

    public function editar($id)
    {
        if(!isset($this->session->id_usuario)) {return redirect()->to(base_url());}
        $servicios=$this -> servicios->where('id',$id)->first();
        $data=['vTITULO' => 'Editar Servicio', 'vDATOS' => $servicios];

        echo view('header');
        echo view('servicios/editar',$data);
        echo view('footer');
    }

    public function actualizar()
    {
        if(!isset($this->session->id_usuario)) {return redirect()->to(base_url());}
        $this->servicios->update($this->request->getPost('id'), [
        'nombre' => $this->request->getPost('nombre')]);
        return redirect()->to(base_url().'/servicios');
    }   
}