<?php namespace App\Controllers;

use App\Controllers\BaseController;
use App\Models\Cie10Model;

class cie10 extends BaseController
{
    protected $session, $cie10;

    public function __construct()
    {
        $this->session = session();
        $this->cie10= new Cie10Model();
    }

    public function index()
    {
        $cie10=$this -> cie10 -> findAll();
        $datos=['vTITULO' => 'Clasificación Internacional de Enfermedades', 'vDATOS' => $cie10];

        echo view('header');
        echo view('cie10/listado',$datos);
        echo view('footer');
    }

    public function editar($id)
    {
        if(!isset($this->session->id_usuario)) {return redirect()->to(base_url());}
        $cie10=$this -> cie10->where('id',$id)->first();
        $data=['vTITULO' => 'Editar CIE', 'vDATOS' => $cie10];

        echo view('header');
        echo view('cie10/editar',$data);
        echo view('footer');
    }

    public function actualizar()
    {
        if(!isset($this->session->id_usuario)) {return redirect()->to(base_url());}
        $this->cie10->update($this->request->getPost('id'), [
        'diagnostico' => $this->request->getPost('diagnostico')]);
        return redirect()->to(base_url().'/cie10');
    }   
}